/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs;

import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.rcs.RcsCallbackSegmentThread;
import com.ibm.hwmca.fw.rcs.conndata.CecInfo;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigEvent;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigListener;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.rcs.path.InvalidStateException;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathCancelledException;
import com.ibm.hwmca.fw.rcs.path.PathCancelledListener;
import com.ibm.hwmca.fw.rcs.path.PathFailedException;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.rcs.path.PathState;
import com.ibm.hwmca.fw.rcs.path.RcsPath;
import com.ibm.hwmca.fw.rcs.path.RemoteServiceCallHomePath;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class RcsCallbackSegment
implements InboundConfigListener,
PathCancelledListener {
    private static NativeBridge bridge;
    private static RcsCallbackSegment segment;
    private static final String OUR_NAME = "com.ibm.hwmca.fw.rcs.rcsCallbackSegment";
    private static RcsPath sessionPath;
    private static InboundConfigManager inCfgMgr;
    private static OutboundConfigManager outCfgMgr;
    private static boolean allowingUnattendedService;
    private static final String RCS_CONTROL = "rcsControl.pl";
    private static final String RUN_MODEM_ANSWER = "--runmodemanswer";
    private static final String STOP_MODEM_ANSWER = "--stopmodemanswer";
    private static final int RC_CALLING_THROUGH_INTERNET_VPN = 1;
    private static final int RC_CALLING_THROUGH_MODEM = 2;
    private static final int RC_NOT_CALL_HOME_SERVER = -1;
    private static final int RC_NOT_CONFIGURED_FOR_MODEM_OR_VPN = -2;
    private static final int RC_VPN_UNAVAILAVBLE_AND_MODEM_NOT_ALLOWED = -3;
    private static final int RC_INVALID_PATH_STATE = -4;
    private static final int RC_PATH_ALREADY_CANCELLED = -5;
    private static final int RC_PATH_FAILED_EXCEPTION = -6;
    private static final int RC_UNCAUGHT_EXCEPTION = -7;
    private static final int RC_PATH_OPEN_FAILED = -8;
    private static final int RC_PARANOIA_PATH_1 = -9;
    private static final int RC_PARANOIA_PATH_2 = -10;
    private static final String TRACE_MASKT = "XRCSCBST";
    private static final String TRACE_MASKF = "XRCSCBSF";
    private static final String TRACE_MASKD = "XRCSCBSD";
    private static FrameworkClassLogInfo classLogInfo;
    private static boolean alreadyRunning;
    private static String signalFileName;
    private static String signalFilePath;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$rcs$link$AttLink;

    private RcsCallbackSegment() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment()");
        File file = new File(signalFilePath, signalFileName);
        FileOutputStream out = null;
        OutputStreamWriter outStream = null;
        try {
            out = new FileOutputStream(file);
            outStream = new OutputStreamWriter((OutputStream)out, "UTF8");
            outStream.write("1234", 0, 4);
            outStream.close();
        }
        catch (FileNotFoundException fnfe) {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegment.setSignalFile() - FileNotFoundException");
            new FrameworkLog(classLogInfo, 1942, fnfe).log(FrameworkLogAttributes.INFO_LOG);
        }
        catch (UnsupportedEncodingException ueee) {
            Trace.trace(TRACE_MASKF, "RcsCallbackSegment.setSignalFile() - UnsupportedEncodingException");
            new FrameworkLog(classLogInfo, 1942, ueee).log(FrameworkLogAttributes.INFO_LOG);
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "   RcsCallbackSegment.setSignalFile() - IOException");
            new FrameworkLog(classLogInfo, 1942, ioe).log(FrameworkLogAttributes.INFO_LOG);
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment()");
    }

    public static void run() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.run()");
        if (!alreadyRunning) {
            alreadyRunning = true;
            segment = new RcsCallbackSegment();
            inCfgMgr = InboundConfigManager.getInboundConfigManager();
            outCfgMgr = OutboundConfigManager.getOutboundConfigManager();
            inCfgMgr.addInboundConfigListener(segment);
            RcsCallbackSegment.adjustModemMonitor();
            bridge = new NativeBridge();
            NativeProcessParameters nativeProcessParameters = new NativeProcessParameters("actzNativeBridgeMain");
            try {
                bridge.exec(nativeProcessParameters);
                NativeBridge.registerGlobalObject(segment, OUR_NAME);
            }
            catch (IOException ioe) {
                Trace.trace(TRACE_MASKF, "RcsCallbackSegment.run() failed");
                new FrameworkLog(classLogInfo, 1942, ioe).log(FrameworkLogAttributes.INFO_LOG);
                return;
            }
            RcsCallbackSegmentThread thr = new RcsCallbackSegmentThread(inCfgMgr);
            thr.start();
        } else {
            Trace.trace(TRACE_MASKF, "RcsCallbackSegment.run() called more than once!!");
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.run()");
    }

    public int allowUnattendedService() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.allowUnattendedService()");
        int rc = 0;
        InboundConfigData configData = inCfgMgr.getInboundConfig();
        if (configData.isAllowUnattendedService()) {
            rc = 1;
            Trace.trace(TRACE_MASKF, "RcsCallbackSegment.allowUnattendedService() - ENABLED");
        } else {
            Trace.trace(TRACE_MASKF, "RcsCallbackSegment.allowUnattendedService() - DISABLED");
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.allowUnattendedService()");
        return rc;
    }

    private static void adjustModemMonitor() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.adjustModemMonitor()");
        int allowOK = segment.allowUnattendedService();
        String command = allowOK != 0 ? "rcsControl.pl --runmodemanswer" : "rcsControl.pl --stopmodemanswer";
        try {
            RootProcess.executeProgram(command);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "RcsCallbackSegment.adjustModemMonitor Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.adjustModemMonitor()");
    }

    public int completeSequence() {
        ArrayList<Class> links;
        CecInfo consoleInfo;
        ArrayList lparInfo;
        String serial;
        String model;
        String type;
        HMC hmc;
        LocalizableText desc;
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.completeSequence()");
        boolean rc = false;
        int path = 1;
        boolean callHomeServer = false;
        OutboundConfigData outCfgData = outCfgMgr.getOutboundConfig();
        callHomeServer = outCfgData.isCallHomeServer();
        if (!callHomeServer) {
            Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence() - fail-not callhome");
            return -1;
        }
        if (outCfgData.isAllowInternet()) {
            desc = new LocalizableText("Remote service VPN session");
            hmc = HMC.getHMC();
            type = hmc.getMachineType();
            model = hmc.getMachineModel();
            serial = hmc.getMachineSerial();
            lparInfo = new ArrayList();
            consoleInfo = new CecInfo(type, model, serial, "HMC", lparInfo);
            sessionPath = new RemoteServiceCallHomePath(PathPlatform.STORAGE, PathPriority.HIGH, desc, true, consoleInfo, null);
            links = new ArrayList<Class>();
            links.add(class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink == null ? (class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink = RcsCallbackSegment.class$("com.ibm.hwmca.fw.rcs.link.InternetVpnLink")) : class$com$ibm$hwmca$fw$rcs$link$InternetVpnLink);
            links.add(class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink == null ? (class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink = RcsCallbackSegment.class$("com.ibm.hwmca.fw.rcs.link.L2tpVpnLink")) : class$com$ibm$hwmca$fw$rcs$link$L2tpVpnLink);
            links.add(class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink == null ? (class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink = RcsCallbackSegment.class$("com.ibm.hwmca.fw.rcs.link.L2tpAttLink")) : class$com$ibm$hwmca$fw$rcs$link$L2tpAttLink);
            sessionPath.setSupportedLinkTypes(links);
            try {
                sessionPath.waitForAvailability();
                sessionPath.setCancelListener(segment);
                sessionPath.open();
                if (sessionPath.getPathIdentifier().getState() == PathState.ACTIVE) {
                    Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-succcess VPN");
                    return 1;
                }
                Trace.trace(TRACE_MASKF, sessionPath.getPathIdentifier().getState().getDescription().toString());
                path = 1;
            }
            catch (InvalidStateException ise) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-Invalid path state");
                return -4;
            }
            catch (PathCancelledException pce) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-Path already cancelled");
                return -5;
            }
            catch (PathFailedException pfe) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-path failed");
                return -6;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-Uncaught exception");
                sessionPath.close();
                return -7;
            }
        } else {
            path = 2;
        }
        if (!outCfgData.isAllowDial()) {
            if (path == 1) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-fail-no VPN");
                return -3;
            }
            if (path == 2) {
                Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-fail-not configured");
                return -2;
            }
            Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.completeSequence()-fail-par1");
            return -9;
        }
        desc = new LocalizableText("Remote service modem session");
        hmc = HMC.getHMC();
        type = hmc.getMachineType();
        model = hmc.getMachineModel();
        serial = hmc.getMachineSerial();
        lparInfo = new ArrayList();
        consoleInfo = new CecInfo(type, model, serial, "HMC", lparInfo);
        sessionPath = new RemoteServiceCallHomePath(PathPlatform.STORAGE, PathPriority.HIGH, desc, true, consoleInfo, null);
        links = new ArrayList();
        links.add(class$com$ibm$hwmca$fw$rcs$link$AttLink == null ? (class$com$ibm$hwmca$fw$rcs$link$AttLink = RcsCallbackSegment.class$("com.ibm.hwmca.fw.rcs.link.AttLink")) : class$com$ibm$hwmca$fw$rcs$link$AttLink);
        sessionPath.setSupportedLinkTypes(links);
        try {
            sessionPath.waitForAvailability();
            RcsCallbackSegmentThread thr = new RcsCallbackSegmentThread(sessionPath);
            thr.start();
            Trace.trace(TRACE_MASKF, "<- RcsCallbackSegment.completeSequence()-spawning thread");
            return 2;
        }
        catch (InvalidStateException ise) {
            Trace.trace(TRACE_MASKF, "<- RcsCallbackSegment.completeSequence()-Invalid path state");
            return -4;
        }
        catch (PathCancelledException pce) {
            Trace.trace(TRACE_MASKF, "<- RcsCallbackSegment.completeSequence()-Path cancelled");
            return -5;
        }
    }

    public void pathCancelled(PathCancelReason reason) {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.pathCancelled()");
        RcsCallbackSegment.adjustModemMonitor();
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.pathCancelled()");
    }

    public void inboundConfigChanged(InboundConfigEvent event) {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.inboundConfigChanged()");
        RcsCallbackSegment.adjustModemMonitor();
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.inboundConfigChanged()");
    }

    protected void finalize() {
        Trace.trace(TRACE_MASKT, "-> RcsCallbackSegment.finalize()");
        NativeBridge.deregisterGlobalObject(OUR_NAME);
        Trace.trace(TRACE_MASKT, "<- RcsCallbackSegment.finalize()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        sessionPath = null;
        inCfgMgr = null;
        outCfgMgr = null;
        allowingUnattendedService = false;
        classLogInfo = new FrameworkClassLogInfo(85, "RCS-CallBkSq");
        alreadyRunning = false;
        signalFileName = "pathStatusSignal";
        signalFilePath = "/tmp/";
    }
}

